
from gurobipy import *

# Create a new model
m = Model("Investment_Optimization")

# Define decision variables
x_f = m.addVar(name='fertilizer_investment', lb=0)
x_p = m.addVar(name='pesticide_investment', lb=0)

# Objective function: Maximize profit
m.setObjective(0.14*x_f + 0.15*x_p, GRB.MAXIMIZE)

# Constraints
m.addConstr(x_f + x_p <= 5000, name='total_investment_limit')
m.addConstr(x_f >= 0.5*(x_f + x_p), name='fertilizer_percentage_minimum')
m.addConstr(x_p >= 1000, name='pesticide_minimum_investment')

# Optimize the model
m.optimize()

# Print results
for v in m.getVars():
    print(f"{v.varName}: {v.x}")

print(f"Objective Function Value: {m.objVal}")
