
import gurobi

def solve_investment_problem():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    x1 = model.addVar(lb=0, name="Fertilizer_Investment")
    x2 = model.addVar(lb=0, name="Pesticide_Investment")

    # Objective function: Maximize profit
    model.setObjective(0.14 * x1 + 0.15 * x2, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(x1 + x2 <= 5000, name="Total_Investment")
    model.addConstr(x1 - x2 >= 0, name="Fertilizer_Min_Investment")
    model.addConstr(x2 >= 1000, name="Pesticide_Min_Investment")

    # Optimize
    model.optimize()

    # Print solution
    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal investment in fertilizer company: ${x1.varValue:.2f}")
        print(f"Optimal investment in pesticide company: ${x2.varValue:.2f}")
        print(f"Maximal profit: ${0.14 * x1.varValue + 0.15 * x2.varValue:.2f}")
    else:
        print("The problem is infeasible.")

if __name__ == "__main__":
    solve_investment_problem()
