
import gurobipy as gp

# Create a new model
model = gp.Model("vitamin_supplements")

# Create variables
x = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="chewable_pills")
y = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="regular_pills")

# Set objective function
model.setObjective(0.5 * x + 0.4 * y, gp.GRB.MINIMIZE)

# Add constraints
model.addConstr(2 * x + 3 * y >= 30, "vitamin_A")
model.addConstr(3 * x + 2 * y >= 20, "vitamin_C")
model.addConstr(3 * x + 4 * y >= 40, "vitamin_D")
model.addConstr(2 * x + 4 * y >= 30, "vitamin_E")

# Optimize model
model.optimize()

# Print results
if model.status == gp.GRB.OPTIMAL:
    print(f"Optimal cost: ${model.objVal:.2f}")
    print(f"Chewable pills: {x.x:.2f}")
    print(f"Regular pills: {y.x:.2f}")
else:
    print("Infeasible or unbounded")

