
from gurobipy import *

# Create a new model
m = Model("Vitamin_Supplements")

# Define the decision variables
x = m.addVar(vtype=GRB.CONTINUOUS, name="chewable_pills", lb=0)
y = m.addVar(vtype=GRB.CONTINUOUS, name="regular_pills", lb=0)

# Define the objective function
m.setObjective(0.50*x + 0.40*y, GRB.MINIMIZE)

# Add the constraints
m.addConstr(2*x + 3*y >= 30, "Vitamin_A")
m.addConstr(3*x + 2*y >= 20, "Vitamin_C")
m.addConstr(3*x + 4*y >= 40, "Vitamin_D")
m.addConstr(2*x + 4*y >= 30, "Vitamin_E")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Chewable pills: {x.x}")
    print(f"Regular pills: {y.x}")
    print(f"Total cost: ${0.50*x.x + 0.40*y.x:.2f}")
else:
    print("No optimal solution found")
