
import gurobi

def solve_supplement_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x = model.addVar(name="chewable_pills", lb=0, vtype=gurobi.GRB.CONTINUOUS)
    y = model.addVar(name="regular_pills", lb=0, vtype=gurobi.GRB.CONTINUOUS)

    # Define the objective function
    model.setObjective(0.50 * x + 0.40 * y, gurobi.GRB.MINIMIZE)

    # Add constraints
    model.addConstr(2 * x + 3 * y >= 30, name="vitamin_A")
    model.addConstr(3 * x + 2 * y >= 20, name="vitamin_C")
    model.addConstr(3 * x + 4 * y >= 40, name="vitamin_D")
    model.addConstr(2 * x + 4 * y >= 30, name="vitamin_E")

    # Solve the model
    model.optimize()

    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal solution: x = {x.varValue:.2f}, y = {y.varValue:.2f}")
        print(f"Minimum cost: ${model.objVal:.2f}")
    elif model.status == gurobi.GRB.INFEASIBLE:
        print("The model is infeasible.")
    else:
        print("The model has an unknown status.")

solve_supplement_problem()
