
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("drug_mixture")

# Create variables
x = m.addVar(lb=0, name="drug_A")
y = m.addVar(lb=0, name="drug_B")

# Set objective function
m.setObjective(0.5 * x + 0.3 * y, GRB.MINIMIZE)

# Add constraints
m.addConstr(3 * x + 2 * y >= 5, "pain_killer")
m.addConstr(2.5 * x + 3.5 * y >= 12, "fever_reliever")

# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal cost: ${m.objVal:.2f}")
    print(f"Drug A: {x.x:.2f} mg")
    print(f"Drug B: {y.x:.2f} mg")
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

