
from gurobipy import *

# Create a new model
m = Model("Drug_Mixture")

# Define the decision variables
x_A = m.addVar(name="drug_A", lb=0)
x_B = m.addVar(name="drug_B", lb=0)

# Define the objective function
m.setObjective(0.50*x_A + 0.30*x_B, GRB.MINIMIZE)

# Add constraints
m.addConstr(3*x_A + 2*x_B >= 5, name="pain_killer_constraint")
m.addConstr(2.5*x_A + 3.5*x_B >= 12, name="fever_reliever_constraint")

# Optimize the model
m.optimize()

# Print the solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Amount of Drug A: {x_A.x} mg")
    print(f"Amount of Drug B: {x_B.x} mg")
    print(f"Total Cost: ${0.50*x_A.x + 0.30*x_B.x}")
else:
    print("No optimal solution found.")
