
import gurobi

def solve_mixture_problem():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    x = model.addVar(name="drug_A", lb=0, ub=gurobi.GRB.INFINITY)
    y = model.addVar(name="drug_B", lb=0, ub=gurobi.GRB.INFINITY)

    # Objective function: minimize cost
    model.setObjective(0.50 * x + 0.30 * y, gurobi.GRB.MINIMIZE)

    # Constraints
    model.addConstr(3 * x + 2 * y >= 5, name="pain_killer")
    model.addConstr(2.5 * x + 3.5 * y >= 12, name="fever_reliever")

    # Optimize
    model.optimize()

    # Print solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal cost: ", model.objVal)
        print("Amount of drug A: ", x.varValue)
        print("Amount of drug B: ", y.varValue)
    else:
        print("The problem is infeasible")

solve_mixture_problem()
