
import gurobipy as gp

# Create a new model
model = gp.Model("Pill Optimization")

# Create decision variables
x = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="blue_pills")
y = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="red_pills")

# Set objective function
model.setObjective(1*x + 2*y, gp.GRB.MINIMIZE)

# Add constraints
model.addConstr(10*x + 5*y >= 100, "blood_pressure_req")
model.addConstr(3*x + 7*y >= 70, "diabetes_req")

# Optimize the model
model.optimize()

# Print the solution
if model.status == gp.GRB.OPTIMAL:
    print(f"Optimal solution found. Cost: ${model.objVal}")
    print(f"Number of blue pills: {x.x}")
    print(f"Number of red pills: {y.x}")
elif model.status == gp.GRB.INFEASIBLE:
    print("Model is infeasible.")
else:
    print(f"Optimization terminated with status: {model.status}")

