
from gurobipy import *

# Create a new model
m = Model("Pill_Purchase")

# Define the decision variables
B = m.addVar(vtype=GRB.INTEGER, name="Blue_Pills", lb=0)
R = m.addVar(vtype=GRB.INTEGER, name="Red_Pills", lb=0)

# Set the objective function: minimize the total cost
m.setObjective(1*B + 2*R, GRB.MINIMIZE)

# Add constraints
m.addConstr(10*B + 5*R >= 100, "Blood_Pressure_Requirement")
m.addConstr(3*B + 7*R >= 70, "Diabetes_Requirement")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print(f"Optimal solution: Buy {int(B.x)} blue pills and {int(R.x)} red pills.")
else:
    print("No optimal solution found.")

