
import gurobi

# Create a new Gurobi model
model = gurobi.Model()

# Define the decision variables
x = model.addVar(lb=0, name="blue_pills")
y = model.addVar(lb=0, name="red_pills")

# Define the objective function
model.setObjective(x + 2 * y, gurobi.GRB.MINIMIZE)

# Define the constraints
model.addConstr(10 * x + 5 * y >= 100, name="blood_pressure_requirement")
model.addConstr(3 * x + 7 * y >= 70, name="diabetes_requirement")

# Optimize the model
model.optimize()

# Print the solution
if model.status == gurobi.GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Blue pills: {x.varValue}")
    print(f"Red pills: {y.varValue}")
    print(f"Total cost: {model.objVal}")
else:
    print("No optimal solution found.")
