
import gurobipy as gp

# Create a new model
model = gp.Model("Candy Production")

# Create decision variables
x = model.addVar(lb=0, vtype=gp.GRB.INTEGER, name="lemon_candy")  # Integer number of lemon candy packets
y = model.addVar(lb=0, vtype=gp.GRB.INTEGER, name="cherry_candy") # Integer number of cherry candy packets

# Set the objective function
model.setObjective(5*x + 7*y, gp.GRB.MAXIMIZE)

# Add constraints
model.addConstr(20*x + 25*y <= 3000, "time_constraint")
model.addConstr(x <= 100, "lemon_limit")
model.addConstr(y <= 80, "cherry_limit")

# Optimize the model
model.optimize()

# Print the results
if model.status == gp.GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Number of lemon candy packets: {x.x}")
    print(f"Number of cherry candy packets: {y.x}")
    print(f"Maximum Profit: ${model.objVal}")
elif model.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status: {model.status}")

