
from gurobipy import *

# Create a new model
m = Model("Candy Store Profit Maximization")

# Define the decision variables
L = m.addVar(lb=0, vtype=GRB.INTEGER, name="LemonCandyPackets")
C = m.addVar(lb=0, vtype=GRB.INTEGER, name="CherryCandyPackets")

# Set the objective function to maximize profit
m.setObjective(5*L + 7*C, GRB.MAXIMIZE)

# Add constraints
m.addConstr(20*L + 25*C <= 3000, "TimeConstraint")
m.addConstr(L <= 100, "LemonCandyQuantityConstraint")
m.addConstr(C <= 80, "CherryCandyQuantityConstraint")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print(f"Optimal solution found: {L.varName} = {L.x}, {C.varName} = {C.x}")
    print(f"Maximum Profit: ${5*L.x + 7*C.x}")
else:
    print("No optimal solution found")
