
import gurobi

# Create a new Gurobi model
m = gurobi.Model()

# Define the variables
L = m.addVar(lb=0, ub=100, name="Lemon_Candy")
C = m.addVar(lb=0, ub=80, name="Cherry_Candy")

# Define the objective function
m.setObjective(5*L + 7*C, gurobi.GRB.MAXIMIZE)

# Define the constraints
m.addConstr(20*L + 25*C <= 3000, name="Time_Constraint")

# Solve the model
m.optimize()

# Print the solution
if m.status == gurobi.GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Lemon Candy: {L.varValue}")
    print(f"Cherry Candy: {C.varValue}")
    print(f"Max Profit: {m.objVal}")
else:
    print("No optimal solution found.")
