
import gurobipy as gp

# Create a new model
model = gp.Model("ToyProduction")

# Create decision variables
x = model.addVar(vtype=gp.GRB.INTEGER, name="trains")  # Integer number of trains
y = model.addVar(vtype=gp.GRB.INTEGER, name="planes")  # Integer number of planes


# Set the objective function
model.setObjective(7*x + 9*y, gp.GRB.MAXIMIZE)

# Add constraints
model.addConstr(30*x + 40*y <= 5000, "building_time")
model.addConstr(40*x + 50*y <= 6000, "painting_time")


# Optimize the model
model.optimize()

# Print the results
if model.status == gp.GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Number of trains to produce: {x.x}")
    print(f"Number of planes to produce: {y.x}")
    print(f"Maximum profit: ${model.objVal}")
elif model.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {model.status}")

