
from gurobipy import *

# Create a new model
m = Model("Model_Trains_Planes")

# Define the decision variables
T = m.addVar(vtype=GRB.INTEGER, name="model_trains", lb=0)
P = m.addVar(vtype=GRB.INTEGER, name="model_planes", lb=0)

# Set the objective function
m.setObjective(7*T + 9*P, GRB.MAXIMIZE)

# Add constraints
m.addConstr(30*T + 40*P <= 5000, "building_time")
m.addConstr(40*T + 50*P <= 6000, "painting_time")

# Optimize the model
m.optimize()

# Print the solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Model Trains: {T.x}")
    print(f"Model Planes: {P.x}")
    print(f"Maximum Profit: ${7*T.x + 9*P.x}")
else:
    print("No optimal solution found")
