
import gurobi

def solve_model_trains_and_planes():
    # Create a new model
    m = gurobi.Model()

    # Define variables
    x = m.addVar(name="model_trains", obj=7, vtype=gurobi.GRB.INTEGER)
    y = m.addVar(name="model_planes", obj=9, vtype=gurobi.GRB.INTEGER)

    # Building time constraint
    m.addConstr(30*x + 40*y <= 5000, name="building_time")

    # Painting time constraint
    m.addConstr(40*x + 50*y <= 6000, name="painting_time")

    # Solve the model
    m.optimize()

    if m.status == gurobi.GRB.OPTIMAL:
        print("Optimal Solution:")
        print(f"Model Trains: {x.varValue}")
        print(f"Model Planes: {y.varValue}")
        print(f"Max Profit: {m.objVal}")
    else:
        print("The model is infeasible")

solve_model_trains_and_planes()
