
import gurobipy as gp

# Create a new model
model = gp.Model("CircuitBoardProduction")

# Create decision variables
x = model.addVar(vtype=gp.GRB.CONTINUOUS, name="small_boards")  # Using CONTINUOUS allows fractional boards
y = model.addVar(vtype=gp.GRB.CONTINUOUS, name="large_boards")

# Set objective function
model.setObjective(5*x + 7*y, gp.GRB.MAXIMIZE)

# Add constraints
model.addConstr(10*x + 15*y <= 600, "drilling_constraint")
model.addConstr(15*x + 18*y <= 600, "printing_constraint")
model.addConstr(x >= 0, "small_boards_nonnegative")  # Explicit non-negativity constraints
model.addConstr(y >= 0, "large_boards_nonnegative")


# Optimize the model
model.optimize()

# Print the results
if model.status == gp.GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Number of small circuit boards: {x.x}")
    print(f"Number of large circuit boards: {y.x}")
    print(f"Maximum Profit: ${model.objVal}")
elif model.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status: {model.status}")

