
from gurobipy import *

# Create a new model
m = Model("Circuit_Boards")

# Define variables
x = m.addVar(vtype=GRB.CONTINUOUS, name="small_circuit_boards", lb=0)
y = m.addVar(vtype=GRB.CONTINUOUS, name="large_circuit_boards", lb=0)

# Set the objective function: maximize profit
m.setObjective(5*x + 7*y, GRB.MAXIMIZE)

# Add constraints
m.addConstr(10*x + 15*y <= 600, "drilling_machine_time")
m.addConstr(15*x + 18*y <= 600, "printing_machine_time")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Small Circuit Boards: {x.x}")
    print(f"Large Circuit Boards: {y.x}")
    print(f"Maximum Profit: ${5*x.x + 7*y.x:.2f}")
else:
    print("No optimal solution found.")
