
import gurobi

# Create a new Gurobi model
model = gurobi.Model()

# Define the decision variables
x = model.addVar(lb=0, name="small_circuit_boards")
y = model.addVar(lb=0, name="large_circuit_boards")

# Define the objective function
model.setObjective(5 * x + 7 * y, gurobi.GRB.MAXIMIZE)

# Define the constraints
drilling_constraint = model.addConstr(10 * x + 15 * y <= 600, name="drilling_machine")
printing_constraint = model.addConstr(15 * x + 18 * y <= 600, name="printing_machine")

# Optimize the model
model.optimize()

# Print the solution
if model.status == gurobi.GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Number of small circuit boards: {x.varValue}")
    print(f"Number of large circuit boards: {y.varValue}")
    print(f"Maximum profit: ${model.objVal:.2f}")
else:
    print("No optimal solution found.")
