
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("fruit_packages")

# Create variables
x = m.addVar(vtype=GRB.CONTINUOUS, name="mango_lovers")
y = m.addVar(vtype=GRB.CONTINUOUS, name="regular")


# Set objective
m.setObjective(5*x + 6.5*y, GRB.MAXIMIZE)

# Add constraints
m.addConstr(4*x + 3*y <= 30, "lemon_constraint")
m.addConstr(8*x + 5*y <= 40, "mango_constraint")
m.addConstr(10*y <= 50, "pear_constraint")

# Optimize model
m.optimize()

if m.status == GRB.OPTIMAL:
    print(f"Mango-lovers packages: {x.x}")
    print(f"Regular packages: {y.x}")
    print(f"Optimal profit: {m.objVal}")
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {m.status}")

