
from gurobipy import *

# Create a new model
m = Model("Fruit Store Optimization")

# Define the decision variables
x1 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="MangoLoversPackages")
x2 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="RegularPackages")

# Define the constraints
m.addConstr(4*x1 + 3*x2 <= 30, "LemonsConstraint")
m.addConstr(8*x1 + 5*x2 <= 40, "MangosConstraint")
m.addConstr(10*x2 <= 50, "PearsConstraint")

# Define the objective function
m.setObjective(5*x1 + 6.5*x2, GRB.MAXIMIZE)

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print(f"Optimal solution found: {x1.varName} = {x1.x}, {x2.varName} = {x2.x}")
    print(f"Maximum profit: {m.objVal} euros")
else:
    print("No optimal solution found")

