
import gurobi

# Create a new model
model = gurobi.Model()

# Define the variables
x = model.addVar(name="mango_lovers_packages", lb=0, vtype=gurobi.GRB.CONTINUOUS)
y = model.addVar(name="regular_packages", lb=0, vtype=gurobi.GRB.CONTINUOUS)

# Define the objective function
model.setObjective(5 * x + 6.5 * y, gurobi.GRB.MAXIMIZE)

# Add constraints
model.addConstr(4 * x + 3 * y <= 30, name="lemons_constraint")
model.addConstr(8 * x + 5 * y <= 40, name="mangos_constraint")
model.addConstr(10 * y <= 50, name="pears_constraint")

# Optimize the model
model.optimize()

# Print the results
if model.status == gurobi.GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Mango-lovers packages: {x.varValue}")
    print(f"Regular packages: {y.varValue}")
    print(f"Max Profit: {model.objVal}")
else:
    print("No optimal solution found.")
