
import gurobipy as gp

# Create a new model
model = gp.Model("SuitcaseProduction")

# Create decision variables
x = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="carry_on")
y = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="large")

# Set objective function
model.setObjective(100*x + 150*y, gp.GRB.MAXIMIZE)

# Add constraints
model.addConstr(x <= 15, "carry_on_limit")
model.addConstr(y <= 20, "large_limit")
model.addConstr(x + y <= 25, "sewing_machine_capacity")

# Optimize the model
model.optimize()

# Print the results
if model.status == gp.GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Number of carry-on suitcases: {x.x}")
    print(f"Number of large suitcases: {y.x}")
    print(f"Optimal Profit: ${model.objVal}")
elif model.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {model.status}")

