
from gurobipy import *

# Create a new model
m = Model("Luggage_Production")

# Define variables
x_c = m.addVar(lb=0, vtype=GRB.INTEGER, name="carry_on_suitcases")
x_l = m.addVar(lb=0, vtype=GRB.INTEGER, name="large_suitcases")

# Set the objective function: Maximize profit
m.setObjective(100*x_c + 150*x_l, GRB.MAXIMIZE)

# Add constraints
m.addConstr(x_c <= 15, "carry_on_production_limit")
m.addConstr(x_l <= 20, "large_production_limit")
m.addConstr(x_c + x_l <= 25, "sewing_machine_capacity")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Carry-on suitcases to produce: {x_c.x}")
    print(f"Large suitcases to produce: {x_l.x}")
    print(f"Maximum profit achievable: ${m.objVal}")
else:
    print("No optimal solution found. The problem might be infeasible.")
