
import gurobipy as gp

# Create a new model
model = gp.Model("Luggage_Production")

# Define the decision variables
x1 = model.addVar(lb=0, ub=15, name="carry_on_suitcases")
x2 = model.addVar(lb=0, ub=20, name="large_suitcases")

# Define the objective function
model.setObjective(100*x1 + 150*x2, gp.GRB.MAXIMIZE)

# Add constraints
model.addConstr(x1 <= 15, name="carry_on_production_limit")
model.addConstr(x2 <= 20, name="large_production_limit")
model.addConstr(x1 + x2 <= 25, name="sewing_machine_capacity")

# Optimize the model
model.optimize()

# Print the results
if model.status == gp.GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Carry-on suitcases: {x1.varValue}")
    print(f"Large suitcases: {x2.varValue}")
    print(f"Maximum profit: ${model.objVal:.2f}")
else:
    print("No optimal solution found.")
