
import gurobipy as gp
from gurobipy import GRB

# Create a new model
model = gp.Model("Amazing_Decor")

# Create decision variables
f = model.addVar(vtype=GRB.INTEGER, name="furniture")
c = model.addVar(vtype=GRB.INTEGER, name="carpet")

# Set objective function
model.setObjective(40 * f + 30 * c, GRB.MAXIMIZE)

# Add constraints
model.addConstr(12 * f + 7 * c <= 1200, "space_constraint")
model.addConstr(300 * f + 80 * c <= 30000, "budget_constraint")
model.addConstr(f >= 0.2 * (f + c), "furniture_proportion")

# Optimize model
model.optimize()

# Print results
if model.status == GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Number of furniture to buy and sell: {f.x}")
    print(f"Number of carpets to buy and sell: {c.x}")
    print(f"Maximum Profit: ${model.objVal}")
elif model.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status: {model.status}")

