
from gurobipy import *

# Create a model
m = Model("Amazing Decor Optimization")

# Define variables
F = m.addVar(vtype=GRB.INTEGER, name="Furniture")
C = m.addVar(vtype=GRB.INTEGER, name="Carpet")

# Set the objective function: Maximize profit
m.setObjective(40*F + 30*C, GRB.MAXIMIZE)

# Add constraints
# Space constraint
m.addConstr(12*F + 7*C <= 1200, "SpaceConstraint")
# Budget constraint
m.addConstr(300*F + 80*C <= 30000, "BudgetConstraint")
# Furniture proportion constraint
m.addConstr(F >= 0.2*(F + C), "FurnitureProportionConstraint")

# Non-negativity constraints (implicitly handled by GRB.INTEGER with lower bound of 0)

# Solve the model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal solution: Buy and sell {F.x} furniture and {C.x} carpets.")
    print(f"Maximum profit: ${40*F.x + 30*C.x}")
else:
    print("No optimal solution found. The problem might be infeasible.")
