
import gurobipy as gp

# Create a new model
model = gp.Model("Amazing_Decor_Optimization")

# Decision variables
F_b = model.addVar(name="Furniture_Buy", vtype=gp.GRB.INTEGER, lb=0)
C_b = model.addVar(name="Carpet_Buy", vtype=gp.GRB.INTEGER, lb=0)
F_s = F_b  # Assuming what is bought is sold
C_s = C_b  # Assuming what is bought is sold

# Objective function: Maximize profit
model.setObjective(40*F_s + 30*C_s, gp.GRB.MAXIMIZE)

# Space constraint
model.addConstr(12*F_b + 7*C_b <= 1200, name="Space_Constraint")

# Budget constraint
model.addConstr(300*F_b + 80*C_b <= 30000, name="Budget_Constraint")

# Furniture percentage constraint
model.addConstr(F_b >= 0.20*(F_b + C_b), name="Furniture_Percentage_Constraint")

# Solve the model
model.optimize()

# Print the results
if model.status == gp.GRB.OPTIMAL:
    print("Optimal Solution:")
    print(f"Furniture to buy: {F_b.varValue}")
    print(f"Carpet to buy: {C_b.varValue}")
    print(f"Profit: {model.objVal}")
else:
    print("No optimal solution found.")
