
import gurobi as gp
from gurobi import GRB

# Create a new model
model = gp.Model("energy_drink_advertising")

# Define variables
x1 = model.addVar(vtype=GRB.INTEGER, name="famous_actors")
x2 = model.addVar(vtype=GRB.INTEGER, name="regular_people")
x3 = model.addVar(vtype=GRB.INTEGER, name="no_people")

# Objective function: Maximize viewership
model.setObjective(50000*x1 + 20000*x2 + 18000*x3, GRB.MAXIMIZE)

# Budget constraint
model.addConstr(10000*x1 + 3000*x2 + 2000*x3 <= 50000, name="budget_constraint")

# Constraint on commercials with regular actors
model.addConstr(x2 <= 3, name="regular_people_constraint")

# Constraint on commercials with no people
model.addConstr(3*x3 <= x1 + x2 + x3, name="no_people_constraint")
model.addConstr(2*x3 <= x1 + x2, name="no_people_constraint_adjusted")

# Constraint on commercials with famous actors
model.addConstr(x1 >= 0.2*(x1 + x2 + x3), name="famous_actors_constraint")
model.addConstr(0.8*x1 >= 0.2*x2 + 0.2*x3, name="famous_actors_constraint_adjusted")
model.addConstr(4*x1 >= x2 + x3, name="famous_actors_constraint_final")

# Non-negativity constraints (handled by variable type)

# Solve the model
model.optimize()

# Print solution
if model.status == GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Famous actors commercials: {x1.varValue}")
    print(f"Regular people commercials: {x2.varValue}")
    print(f"No people commercials: {x3.varValue}")
else:
    print("No optimal solution found.")
