
import gurobipy as gp

# Create a new model
m = gp.Model("investment_optimization")

# Create variables
solar = m.addVar(lb=0, name="solar")
wind = m.addVar(lb=0, name="wind")
nuclear = m.addVar(lb=0, name="nuclear")
coal = m.addVar(lb=0, name="coal")

# Set objective function
m.setObjective(0.06 * solar + 0.09 * wind + 0.12 * nuclear + 0.03 * coal, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(solar + wind + nuclear + coal == 1000000, "total_investment")
m.addConstr(coal <= solar, "coal_solar_constraint")
m.addConstr(wind <= nuclear, "wind_nuclear_constraint")
m.addConstr(coal <= 0.1 * 1000000, "coal_limit")

# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Solar: ${solar.x}")
    print(f"Wind: ${wind.x}")
    print(f"Nuclear: ${nuclear.x}")
    print(f"Coal: ${coal.x}")
    print(f"Total Return: ${m.objVal}")
elif m.status == gp.GRB.INFEASIBLE:
    print("Model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

