
from gurobipy import *

# Create a model
m = Model("Jason_Investment")

# Define variables
s = m.addVar(lb=0, name="solar")  # Investment in solar sector
w = m.addVar(lb=0, name="wind")   # Investment in wind sector
n = m.addVar(lb=0, name="nuclear") # Investment in nuclear sector
c = m.addVar(lb=0, name="coal")    # Investment in coal sector

# Objective function: Maximize total return
m.setObjective(0.06*s + 0.09*w + 0.12*n + 0.03*c, GRB.MAXIMIZE)

# Constraints
m.addConstr(c <= s, "Coal_not_exceed_Solar")
m.addConstr(w <= n, "Wind_not_exceed_Nuclear")
m.addConstr(c <= 100000, "Max_Coal_Investment")
m.addConstr(s + w + n + c == 1000000, "Total_Investment")

# Solve the model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Invest in Solar: ${s.x:.2f}")
    print(f"Invest in Wind: ${w.x:.2f}")
    print(f"Invest in Nuclear: ${n.x:.2f}")
    print(f"Invest in Coal: ${c.x:.2f}")
else:
    print("No optimal solution found.")
