
import gurobi

def solve_investment_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    S = model.addVar(name="solar", lb=0)
    W = model.addVar(name="wind", lb=0)
    N = model.addVar(name="nuclear", lb=0)
    C = model.addVar(name="coal", lb=0)

    # Objective function: Maximize return
    model.setObjective(0.06 * S + 0.09 * W + 0.12 * N + 0.03 * C, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(C <= S, name="coal_solar_constraint")
    model.addConstr(W <= N, name="wind_nuclear_constraint")
    model.addConstr(C <= 100000, name="coal_limit_constraint")
    model.addConstr(S + W + N + C <= 1000000, name="total_investment_constraint")

    # Solve the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal Solution:")
        print(f"Solar: ${S.varValue:.2f}")
        print(f"Wind: ${W.varValue:.2f}")
        print(f"Nuclear: ${N.varValue:.2f}")
        print(f"Coal: ${C.varValue:.2f}")
        print(f"Max Return: ${model.objVal:.2f}")
    else:
        print("No optimal solution found.")

solve_investment_problem()
