
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("calculator_production")

# Create variables
x = m.addVar(vtype=GRB.CONTINUOUS, name="solar_calculators")
y = m.addVar(vtype=GRB.CONTINUOUS, name="finance_calculators")

# Set objective
m.setObjective(12 * x + 9 * y, GRB.MAXIMIZE)

# Add constraints
m.addConstr(5 * x + 3 * y <= 150, "silicon_constraint")
m.addConstr(4 * x + 5 * y <= 150, "plastic_constraint")
m.addConstr(2 * x + 3 * y <= 70, "steel_constraint")

# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal profit: {m.objVal}")
    print(f"Number of solar calculators: {x.x}")
    print(f"Number of finance calculators: {y.x}")
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {m.status}")

