
from gurobipy import *

# Create a new model
m = Model("Calculator_Production")

# Define variables
x1 = m.addVar(vtype=GRB.CONTINUOUS, name="solar_calculators", lb=0)
x2 = m.addVar(vtype=GRB.CONTINUOUS, name="finance_calculators", lb=0)

# Set the objective function
m.setObjective(12*x1 + 9*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(5*x1 + 3*x2 <= 150, "silicon_constraint")
m.addConstr(4*x1 + 5*x2 <= 150, "plastic_constraint")
m.addConstr(2*x1 + 3*x2 <= 70, "steel_constraint")

# Optimize model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print(f"Optimal solution: Produce {x1.x} solar calculators and {x2.x} finance calculators.")
    print(f"Maximum profit: ${12*x1.x + 9*x2.x}")
else:
    print("No optimal solution found")
