
import gurobi

# Create a new Gurobi model
model = gurobi.Model()

# Define the decision variables
x = model.addVar(lb=0, name="solar_calculators")
y = model.addVar(lb=0, name="finance_calculators")

# Define the objective function
model.setObjective(12 * x + 9 * y, gurobi.GRB.MAXIMIZE)

# Define the constraints
model.addConstr(5 * x + 3 * y <= 150, name="silicon_constraint")
model.addConstr(4 * x + 5 * y <= 150, name="plastic_constraint")
model.addConstr(2 * x + 3 * y <= 70, name="steel_constraint")

# Optimize the model
model.optimize()

# Print the solution
if model.status == gurobi.GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Solar calculators: {x.varValue}")
    print(f"Finance calculators: {y.varValue}")
    print(f"Max profit: {model.objVal}")
else:
    print("No optimal solution found.")
