
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("sausage_mixture")

# Create variables
x = m.addVar(lb=0, name="pork") # Kilograms of pork
y = m.addVar(lb=0, name="chicken") # Kilograms of chicken

# Set objective function
m.setObjective(40*x + 50*y, GRB.MINIMIZE)

# Add constraints
m.addConstr(2*x + 3*y >= 10, "protein_req")
m.addConstr(4*x + 2*y >= 15, "fat_req")

# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal cost: ${m.objVal:.2f}")
    print(f"Kilograms of pork: {x.x:.2f}")
    print(f"Kilograms of chicken: {y.x:.2f}")
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {m.status}")

