
from gurobipy import *

# Create a new model
m = Model("Sausage_Mixture")

# Define the decision variables
x_p = m.addVar(lb=0, name="pork")
x_c = m.addVar(lb=0, name="chicken")

# Define the objective function
m.setObjective(40*x_p + 50*x_c, GRB.MINIMIZE)

# Add constraints
m.addConstr(2*x_p + 3*x_c >= 10, name="protein_constraint")
m.addConstr(4*x_p + 2*x_c >= 15, name="fat_constraint")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Pork: {x_p.x} kg")
    print(f"Chicken: {x_c.x} kg")
    print(f"Minimum cost: ${m.objVal}")
else:
    print("No optimal solution found")

