
import gurobi as gp

# Create a new model
model = gp.Model("sausage_mixture")

# Define variables
x = model.addVar(name="pork", lb=0)  # Kilograms of pork
y = model.addVar(name="chicken", lb=0)  # Kilograms of chicken

# Objective function: Minimize cost
model.setObjective(40*x + 50*y, gp.GRB.MINIMIZE)

# Constraints
model.addConstr(2*x + 3*y >= 10, name="protein_requirement")
model.addConstr(4*x + 2*y >= 15, name="fat_requirement")

# Optimize the model
model.optimize()

# Print the status
if model.status == gp.GRB.Status.OPTIMAL:
    print("Optimal solution found.")
    print(f"Optimal cost: ${model.objval:.2f}")
    print(f"Pork: {x.varValue:.2f} kg")
    print(f"Chicken: {y.varValue:.2f} kg")
else:
    print("No optimal solution found.")
