
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("Joel's Diet")

# Create variables
x = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="chocolate_shakes")
y = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="vanilla_smoothies")

# Set objective function
m.setObjective(8*x + 10*y, GRB.MINIMIZE)

# Add constraints
m.addConstr(35*x + 15*y >= 150, "protein_req")
m.addConstr(20*x + 25*y >= 130, "carb_req")
m.addConstr(3*x + 10*y <= 50, "fat_limit")

# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal cost: ${m.objVal:.2f}")
    print(f"Chocolate shakes: {x.x:.2f}")
    print(f"Vanilla smoothies: {y.x:.2f}")
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {m.status}")

