
from gurobipy import *

# Create a new model
m = Model("Joel_Diet")

# Define variables
x1 = m.addVar(lb=0, name="Chocolate_Protein_Shakes")
x2 = m.addVar(lb=0, name="Meal_Replacement_Smoothies")

# Objective function: Minimize cost
m.setObjective(8*x1 + 10*x2, GRB.MINIMIZE)

# Constraints
m.addConstr(35*x1 + 15*x2 >= 150, "Protein_Requirement")
m.addConstr(20*x1 + 25*x2 >= 130, "Carbohydrate_Requirement")
m.addConstr(3*x1 + 10*x2 <= 50, "Fat_Limitation")

# Optimize model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Chocolate Protein Shakes: {x1.x}")
    print(f"Meal Replacement Smoothies: {x2.x}")
    print(f"Total Cost: ${8*x1.x + 10*x2.x:.2f}")
else:
    print("No optimal solution found")
