
import gurobi

# Create a new Gurobi model
model = gurobi.Model()

# Define the variables
x = model.addVar(lb=0, name="chocolate_shakes")
y = model.addVar(lb=0, name="vanilla_smoothies")

# Define the objective function
model.setObjective(8*x + 10*y, gurobi.GRB.MINIMIZE)

# Define the constraints
model.addConstr(35*x + 15*y >= 150, name="protein_constraint")
model.addConstr(20*x + 25*y >= 130, name="carbs_constraint")
model.addConstr(3*x + 10*y <= 50, name="fat_constraint")

# Optimize the model
model.optimize()

# Print the solution
if model.status == gurobi.GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Chocolate shakes: {x.varValue}")
    print(f"Vanilla smoothies: {y.varValue}")
    print(f"Total cost: {model.objVal}")
else:
    print("No optimal solution found.")
