
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("mattress_production")

# Create decision variables
Q = m.addVar(vtype=GRB.CONTINUOUS, name="queen_mattresses") # Allowing fractional mattresses for simplicity.  Change to GRB.INTEGER if only whole mattresses can be produced.
K = m.addVar(vtype=GRB.CONTINUOUS, name="king_mattresses")

# Set objective function
m.setObjective(300*Q + 500*K, GRB.MAXIMIZE)

# Add constraints
m.addConstr(20*Q + 30*K <= 5000, "foam_constraint")
m.addConstr(10*Q + 15*K <= 2500, "packaging_constraint")

# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Number of Queen Mattresses: {Q.x}")
    print(f"Number of King Mattresses: {K.x}")
    print(f"Maximum Profit: ${m.objVal}")
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

