
from gurobipy import *

# Create a new model
model = Model("Mattress_Optimization")

# Define the decision variables
Q = model.addVar(vtype=GRB.CONTINUOUS, name="Queen_Mattresses", lb=0)
K = model.addVar(vtype=GRB.CONTINUOUS, name="King_Mattresses", lb=0)

# Set the objective function: Maximize profit
model.setObjective(300*Q + 500*K, GRB.MAXIMIZE)

# Add constraints
model.addConstr(20*Q + 30*K <= 5000, name="Foam_Availability")
model.addConstr(10*Q + 15*K <= 2500, name="Packaging_Time")

# Optimize the model
model.optimize()

# Print the results
if model.status == GRB.OPTIMAL:
    print(f"Optimal solution found.")
    print(f"Number of Queen Mattresses: {Q.x}")
    print(f"Number of King Mattresses: {K.x}")
    print(f"Maximum Profit: ${300*Q.x + 500*K.x:.2f}")
else:
    print("No optimal solution found. The model is likely infeasible.")
