
import gurobi

# Create a new Gurobi model
m = gurobi.Model()

# Define the decision variables
Q = m.addVar(lb=0, name="Q")  # queen-sized mattresses
K = m.addVar(lb=0, name="K")  # king-sized mattresses

# Define the objective function
m.setObjective(300*Q + 500*K, gurobi.GRB.MAXIMIZE)

# Define the constraints
m.addConstr(20*Q + 30*K <= 5000, name="foam_constraint")
m.addConstr(10*Q + 15*K <= 2500, name="packaging_time_constraint")

# Optimize the model
m.optimize()

# Print the solution
if m.status == gurobi.GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Queen-sized mattresses: {Q.varValue}")
    print(f"King-sized mattresses: {K.varValue}")
    print(f"Max Profit: {m.objVal}")
else:
    print("No optimal solution found.")
