
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("investment_optimization")

# Create decision variables
x = m.addVar(lb=0, name="x")  # Investment in company A
y = m.addVar(lb=0, name="y")  # Investment in company B

# Set objective function
m.setObjective(0.09 * x + 0.12 * y, GRB.MAXIMIZE)

# Add constraints
m.addConstr(x + y <= 500000, "total_investment")
m.addConstr(x >= 2 * y, "investment_ratio")
m.addConstr(y <= 200000, "max_investment_B")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print(f"Optimal investment in company A: ${x.x}")
    print(f"Optimal investment in company B: ${y.x}")
    print(f"Maximum earnings: ${m.objVal}")
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

