
from gurobipy import *

# Create a new model
m = Model("Investment_Optimization")

# Define the decision variables
x_A = m.addVar(lb=0, name="Investment_in_A")
x_B = m.addVar(lb=0, name="Investment_in_B")

# Set the objective function
m.setObjective(0.09*x_A + 0.12*x_B, GRB.MAXIMIZE)

# Add constraints
m.addConstr(x_A + x_B <= 500000, name="Budget_Constraint")
m.addConstr(x_A >= 2*x_B, name="Investment_Ratio_Constraint")
m.addConstr(x_B <= 200000, name="Max_Investment_in_B_Constraint")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f" Invest in Company A: ${x_A.x:.2f}")
    print(f" Invest in Company B: ${x_B.x:.2f}")
    print(f" Maximum Earnings: ${m.objVal:.2f}")
else:
    print("No optimal solution found")

