
import gurobi

def solve_investment_problem():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    x_A = model.addVar(name="Investment_A", lb=0)
    x_B = model.addVar(name="Investment_B", lb=0)

    # Objective: Maximize earnings
    model.setObjective(0.09 * x_A + 0.12 * x_B, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(x_A >= 2 * x_B, name="At_least_twice_B")
    model.addConstr(x_B <= 200000, name="B_at_most_200k")
    model.addConstr(x_A + x_B == 500000, name="Total_investment")

    # Solve the model
    model.optimize()

    # Print the results
    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal investment in A: ${x_A.x:.2f}")
        print(f"Optimal investment in B: ${x_B.x:.2f}")
        print(f"Maximized earnings: ${0.09 * x_A.x + 0.12 * x_B.x:.2f}")
    else:
        print("The model is infeasible.")

solve_investment_problem()
