
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("Gardening Wages")

# Create variables
x = m.addVar(lb=0, vtype=GRB.INTEGER, name="newcomers") # Number of newcomers
y = m.addVar(lb=0, vtype=GRB.INTEGER, name="fulltime") # Number of full-time employees

# Set objective function
m.setObjective(400*x + 700*y, GRB.MINIMIZE)

# Add constraints
m.addConstr(x + y >= 100, "total_gardeners")
m.addConstr(y >= 40, "min_fulltime")
m.addConstr(y >= 0.5*x, "supervision_ratio")


# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Number of newcomers: {x.x}")
    print(f"Number of full-time employees: {y.x}")
    print(f"Minimum Wage Bill: ${m.objVal}")
elif m.status == GRB.INFEASIBLE:
    print("Model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

