
from gurobipy import *

# Create a new model
m = Model("Gardening_Company_Optimization")

# Define the decision variables
x = m.addVar(name="newcomers", lb=0)  # Number of newcomers
y = m.addVar(name="full_time_employees", lb=0)  # Number of full-time employees

# Set the objective function: minimize the total wage bill
m.setObjective(400*x + 700*y, GRB.MINIMIZE)

# Add constraints
m.addConstr(x + y >= 100, name="total_gardeners")  # Total gardeners should be at least 100
m.addConstr(y >= 40, name="min_full_time_employees")  # At least 40 full-time employees
m.addConstr(y >= 0.5*x, name="supervision_ratio")  # Supervision ratio

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Newcomers: {x.x}")
    print(f"Full-time employees: {y.x}")
    print(f"Total wage bill: ${400*x.x + 700*y.x:.2f}")
else:
    print("No optimal solution found")
